PSCAD 4.2.0

Settings
 {
 Id = "890867436.1144361366"
 Author = "nayak.jayas"
 Desc = "Cigre Benchmark, 12 pulse, 500kV, 1000MW"
 Arch = "windows"
 Options = 0
 Build = 22
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.00025
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 767
  Debug = 0
  StartFile = "Untitled.snp"
  OFile = "Cigre.out"
  SFile = "Untitled.snp"
  SnapTime = 1
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  FREQ = 60.0
  }

 }

Definitions
 {
 Component("multimeter")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Choice("MeasI",6,2,224,12,2)
     {
     Style = 0
     Desc = "Measure Instaneous Current ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasV",6,16,224,12,2)
     {
     Style = 0
     Desc = "Measure Instaneous Voltage ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasP",6,30,224,12,2)
     {
     Style = 0
     Desc = "Measure Active Power flow ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasQ",6,44,224,12,2)
     {
     Style = 0
     Desc = "Measure Reactive Power flow ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("RMS",6,58,224,12,2)
     {
     Style = 0
     Desc = "Measure RMS voltage ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes, Analog"
     *2 = "Yes, Digital"
     }
    Input("S",6,72,224,12,2)
     {
     Desc = "Base MVA for per unitizing"
     Def = "1.0"
     Data = Real
     Unit = "MVA"
     Len = 15
     Min = 0
     Max = 500
     Cond = "MeasP||MeasQ"
     }
    Input("BaseV",6,86,224,12,2)
     {
     Desc = "Base voltage for per unitizing"
     Def = "1.0"
     Data = Real
     Unit = "kV"
     Len = 15
     Min = 0
     Max = 500
     Cond = "RMS!=0"
     }
    Input("TS",6,100,224,12,2)
     {
     Desc = "Smoothing Time Constant"
     Def = "0.02"
     Data = Real
     Unit = "s"
     Len = 15
     Min = 0
     Max = 1
     Cond = "MeasP||MeasQ||RMS==1"
     }
    Input("Freq",6,114,224,12,2)
     {
     Desc = "Frequency"
     Def = "60.0"
     Data = Real
     Unit = "Hz"
     Len = 15
     Min = 0
     Cond = "RMS==2"
     }
    Choice("Dis",6,128,224,12,2)
     {
     Style = 0
     Desc = "Display details?"
     Def = "0"
     Len = 15
     Cond = "MeasP+MeasQ+RMS>0"
     *0 = "No"
     *1 = "Yes"
     }
    }
   Category("Signal Names")
    {
    Input("CurI",6,2,224,12,2)
     {
     Desc = "Instantaneous Current"
     Data = Real
     Len = 15
     Cond = "MeasI"
     }
    Input("VolI",6,16,224,12,2)
     {
     Desc = "Instantaneous Voltage"
     Data = Real
     Len = 15
     Cond = "MeasV"
     }
    Input("P",6,30,224,12,2)
     {
     Desc = "Active Power"
     Data = Real
     Len = 15
     Cond = "MeasP"
     }
    Input("Q",6,44,224,12,2)
     {
     Desc = "Reactive Power"
     Data = Real
     Len = 15
     Cond = "MeasQ"
     }
    Input("Vrms",6,58,224,12,2)
     {
     Desc = "RMS voltage"
     Data = Real
     Len = 15
     Cond = "RMS!=0"
     }
    }
   Category("Animation")
    {
    Cond = "Dis==2"
    Choice("hide1",6,2,80,48,2)
     {
     Style = 1
     Desc = "power"
     Def = "0"
     Len = 15
     *0 = "hide"
     *1 = "show"
     }
    Choice("hide2",100,2,80,48,2)
     {
     Style = 1
     Desc = "rms voltage"
     Def = "0"
     Len = 15
     *0 = "hide"
     *1 = "show"
     }
    }
   }

  Nodes = 
   {
   Electrical("A",-18,0)
    {
    Cond = "MeasV+MeasP+MeasQ+RMS!=0"
    Dim  = [0]
    }
   Electrical("B",18,0)
    {
    Type = Removable
    Dim  = [0]
    }
   Electrical("A",-18,0)
    {
    Cond = "MeasV+MeasP+MeasQ+RMS==0"
    Type = Removable
    Dim  = [0]
    }
   }

  Graphics = 
   {
   Pen(Navy,,ByNode,A)
   Line(-18,0,-4,0)
   Pen(,,0.4)
   Ellipse(-4,-7,11,8)
   Pen(,,ByNode,B)
   Line(11,0,18,0)
   Pen(,,0.4)
   Ellipse(-4,8,11,23)
   Line(-12,0,-12,16)
   Line(3,23,3,27)
   Line(-2,27,8,27)
   Line(0,29,6,29)
   Line(2,32,4,32)
   Pen(Blue,,0.2)
   Line(12,-12,6,-9)
   Line(6,-15,12,-12)
   Line(-1,-12,12,-12)
   Pen(Navy,,0.4)
   Line(-12,16,-4,16)
   Cond = "MeasP*Dis*hide1>0"
   Text(4,-48,"P = %Pd")
   Cond = "MeasQ*Dis*hide1>0"
   Text(4,-34,"Q = %Qd")
   Cond = "RMS*Dis>0"
   Text(1,-20,"V = %Vd")
   Cond = "true"
   Text(3,20,"V")
   Text(3,4,"A")
   }

  Section(EMTDC)
   {
   Branch = "BN = $A $B AMMETER"
   DSOUT = "\
#IF MeasI
 #OUTPUT REAL CurI 0 {$CBR:BN}
#ENDIF
!
#IF MeasV
 #FUNCTION REAL EMTDC_VVDC
 #OUTPUT REAL VolI 0 {$VDC:A:0}
#ENDIF
!
#IF (MeasP+MeasQ) || RMS!=0
 #LOCAL REAL MM_1
 #IF (Dis==1)
  #FUNCTION LOGICAL G_UPDAT
  #LOCAL LOGICAL GUPDT_L
      GUPDT_L = G_UPDAT(100)
 #ENDIF
#ENDIF
!
#IF MeasP
 #IF ($#DIM(A)==3 || $#DIM(B)==3)
  #FUNCTION REAL P3PH3
  #STORAGE STOR:3
  #IF SI != 1.0
      MM_1 = $SI * P3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ELSE
      MM_1 = P3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0) 
  #ENDIF
  #IF Dis==1
      IF (GUPDT_L) CALL PSCAD_AGRG($#Component,MM_1,\"Pd\")
  #ENDIF
 #ELSE
      MM_1 = 0.0
 #ENDIF
 #OUTPUT REAL P {MM_1}
#ENDIF
!
#IF MeasQ
 #IF ($#DIM(A)==3 || $#DIM(B)==3)
  #FUNCTION REAL Q3PH3
  #STORAGE STOR:3
  #IF SI != 1.0
      MM_1 = $SI * Q3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ELSE
      MM_1 = Q3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ENDIF
  #IF Dis==1
      IF (GUPDT_L) CALL PSCAD_AGRG($#Component,MM_1,\"Qd\")
  #ENDIF
 #ELSE
      MM_1 = 0.0
 #ENDIF
 #OUTPUT REAL Q {MM_1}
#ENDIF
!
#IF $#DIM(A)==3
 #IF RMS==1
  #STORAGE STOR:2
  #FUNCTION REAL VM3PH2 '3 Phase RMS Voltage Measurement'
  #IF BaseVI != 1.0
      MM_1 = $BaseVI * VM3PH2($SS, $A(1), $A(2), $A(3), $TS)
  #ELSE
      MM_1 = VM3PH2($SS, $A(1), $A(2), $A(3), $TS) 
  #ENDIF
 #ELSEIF RMS==2
  #SUBROUTINE DGTL_RMS3 '3 Phase Digital RMS Meter'
  #STORAGE REAL:5 INTEGER:2
  #STORAGE REAL:256
      CALL DGTL_RMS3(256,$SS,$A(1),$A(2),$A(3),$FREQ,1.0,0.0,MM_1)
  #IF BaseVI != 1.0
      MM_1 = $BaseVI*MM_1
  #ENDIF
 #ENDIF
 #IF Dis==1
      IF (GUPDT_L) CALL PSCAD_AGRG($#Component,MM_1,\"Vd\")
 #ENDIF
#ELSEIF $#DIM(A)==1
 #IF RMS==1
  #STORAGE STOR:3
  #FUNCTION REAL RMS3 'Instantaneous RMS Measurement'
      MM_1 = RMS3( $VDC:A:0 , $TS )
  #IF BaseVI != 1.0
      MM_1 = $BaseVI*MM_1
  #ENDIF
 #ELSEIF RMS==2
  #SUBROUTINE DGTL_RMS 'RMS Measurement using Digital Samlping'
  #STORAGE REAL:5 INTEGER:2
  #STORAGE REAL:256
      CALL DGTL_RMS(256,$Freq,$VDC:A:0,$BaseVI,0.0,MM_1)
 #ENDIF
 #IF Dis==1
      IF (GUPDT_L) CALL PSCAD_AGRG($#Component,MM_1,\"Vd\")
 #ENDIF
#ELSE
 #IF RMS!=0
      MM_1 = 0.0
 #ENDIF
#ENDIF
#IF RMS!=0
 #OUTPUT REAL Vrms {MM_1}
#ENDIF
#IF (MeasQ || MeasP || RMS) && Dis
      IF (FIRSTSTEP) THEN
 #IF ($#DIM(A)!=3 && $#DIM(B)!=3)
        CALL PSCAD_AGI($#Component,0,\"hide1\")
 #ELSE
        CALL PSCAD_AGI($#Component,1,\"hide1\")
 #ENDIF
 #IF ($#DIM(A)!=3 && $#DIM(A)!=1)
        CALL PSCAD_AGI($#Component,0,\"hide2\")
 #ELSE
        CALL PSCAD_AGI($#Component,1,\"hide2\")
 #ENDIF
      ENDIF
#ENDIF"
   Computations = "\
#IF MeasP||MeasQ
 #IF S!=0.0
  REAL SI=1/S
 #ELSE
  REAL SI=1.0
 #ENDIF
#ENDIF
#IF RMS!=0
 #IF BaseV!=0.0
  REAL BaseVI = 1/BaseV
 #ELSE
  REAL BaseVI = 1.0
 #ENDIF
#ENDIF"
   Checks = "\
#IF $#DIM(A)!=3 && $#DIM(B)!=3
 #IF MeasP||MeasQ
WARNING Power is measured only on 3 phase lines, Selection ignored. : 0>1
 #ENDIF
#ENDIF
#IF RMS!=0 && $#DIM(A)!=1 && $#DIM(A)!=3
WARNING RMS voltage is measured only on 3 phase or single phase lines, Selection ignored. : 0>1
#ENDIF"
   }
  }
 Module("HVDC")
  {
  Desc = "HVDC System"
  FileDate = 0
  Nodes = 
   {
   Electrical("NR",-72,0)
    {
    Dim  = [3]
    }
   Electrical("NI",72,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Ellipse(-61,-4,-52,4)
   Ellipse(-56,-4,-47,4)
   Line(-24,-12,-24,-19)
   Line(24,-12,24,-19)
   Line(24,-19,-24,-19)
   Line(-47,0,-36,0)
   Pen(,,ByNode,NR)
   Line(-72,0,-61,0)
   Pen(,,0.2)
   Ellipse(52,-4,61,4)
   Ellipse(47,-4,56,4)
   Line(36,0,47,0)
   Pen(,,ByNode,NI)
   Line(71,0,61,0)
   Pen(,,0.2)
   Rectangle(-36,-12,-12,11)
   Rectangle(12,-12,36,11)
   Pen(,,0.4)
   Line(-24,-10,-24,-7)
   Line(-33,-7,-15,-7)
   Line(-33,6,-24,-7)
   Line(-15,6,-24,-7)
   Line(-33,6,-15,6)
   Line(-24,6,-24,9)
   Line(24,-10,24,-7)
   Line(33,-7,15,-7)
   Line(15,-7,24,6)
   Line(33,-7,24,6)
   Line(33,6,15,6)
   Line(24,6,24,9)
   Pen(,,0.2)
   Line(9,-24,5,-27)
   Line(5,-21,9,-24)
   Line(-10,-24,9,-24)
   Text(1,24,"%:Name")
   }


  Page(B/A3,Landscape,112,[597,467],100)
   {
   }
  }
 Module("InvCtl")
  {
  Desc = "Inverter Controls"
  FileDate = 1144361330
  Nodes = 
   {
   Input("CMIC",-54,36)
    {
    Type = Real
    }
   Input("GMES",-54,-36)
    {
    Type = Real
    }
   Input("VDCI",-54,0)
    {
    Type = Real
    }
   Output("AOI",54,18)
    {
    Type = Real
    }
   Output("CORDER",54,-18)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Pen(ByNode,ByNode,ByNode,CMIC)
   Line(-54,-36,-29,-36)
   Pen(,Solid)
   Line(-36,-29,-29,-36)
   Line(-29,-36,-36,-42)
   Pen(,ByNode,,GMES)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-36,6,-29,0)
   Line(-29,0,-36,-6)
   Pen(,ByNode,,VDCI)
   Line(-54,36,-29,36)
   Pen(,Solid)
   Line(-36,42,-29,36)
   Line(-29,36,-36,29)
   Pen(Real,Real,0.2)
   Line(54,-18,29,-18)
   Line(54,18,29,18)
   Pen(Black,Solid)
   Brush(Solid,Silver)
   Rectangle(-29,-48,29,48)
   Text(0,63,"%:Desc")
   }


  Page(A/A4,Landscape,48,[597,467],100)
   {
   -Wire-([378,432],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   -Wire-([810,594],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   -Wire-([666,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([702,738],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([1062,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([702,666],2,0,-1)
    {
    Name = "DGEI"
    }
   0.datalabel([774,774],2,0,-1)
    {
    Name = "GERRI"
    }
   0.datalabel([1098,432],2,0,-1)
    {
    Name = "BETAIC"
    }
   -Wire-([738,774],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.sumjct([738,432],6,0,180)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "0 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "-1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   0.sumjct([702,774],6,0,220)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "1 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "-1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   0.pgb([738,666],0,23126488,300)
    {
    Name = "Delta Gamma Error"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "57.2958"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([702,882],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([558,882],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.const([810,810],0,0,120)
    {
    Name = ""
    Value = "-0.544"
    }
   0.maxmin([882,774],0,0,230)
    {
    DPath = "1 [0=Integer;1=Real]"
    Type = "1 [0=Minimum;1=Maximum]"
    A = "0 [0=No;1=Yes]"
    B = "0 [0=No;1=Yes]"
    C = "0 [0=No;1=Yes]"
    D = "1 [0=No;1=Yes]"
    E = "1 [0=No;1=Yes]"
    F = "0 [0=No;1=Yes]"
    G = "0 [0=No;1=Yes]"
    }
   0.datalabel([1098,774],0,0,-1)
    {
    Name = "BETAIG"
    }
   -Wire-([918,774],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1062,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([918,774],0,0,-1)
    {
    Name = "GNLG"
    }
   0.pi_ctlr([1026,774],0,0,240)
    {
    GP = "0.7506"
    TI = "0.0544 [s]"
    YHI = "1.57"
    YLO = "0.52"
    YINIT = "1.57"
    Mthd = "0 [0=Trapezoidal;1=Rectangular]"
    INTR = "0 [0=Disabled;1=Enabled]"
    }
   -Wire-([774,432],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([810,432],2,0,-1)
    {
    Name = "CERRI"
    }
   -Wire-([882,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([882,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([954,360],2,0,50)
    {
    Name = ""
    Value = "0.1"
    }
   0.datalabel([882,360],2,0,-1)
    {
    Name = "CMARG"
    }
   0.sumjct([882,432],6,0,190)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "0 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "-1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   0.pi_ctlr([1026,432],0,0,200)
    {
    GP = "0.63"
    TI = "0.01524 [s]"
    YHI = "1.92"
    YLO = "0.52"
    YINIT = "1.92"
    Mthd = "0 [0=Trapezoidal;1=Rectangular]"
    INTR = "0 [0=Disabled;1=Enabled]"
    }
   -Wire-([918,432],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([954,432],2,0,-1)
    {
    Name = "CERRIM"
    }
   -Wire-([1098,630],0,0,-1)
    {
    Vertex="0,0;0,-198"
    }
   -Wire-([1098,774],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([1170,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.export([1386,630],2,0,290)
    {
    Name = "AOI"
    }
   0.datalabel([1188,630],2,0,-1)
    {
    Name = "BETAI"
    }
   0.pgb([1278,666],0,24729816,280)
    {
    Name = "Alpha Order"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "57.29578"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([1242,630],0,0,260)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "1 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "-1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "0 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   -Wire-([1242,594],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1278,666],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.maxmin([1134,630],0,0,250)
    {
    DPath = "1 [0=Integer;1=Real]"
    Type = "1 [0=Minimum;1=Maximum]"
    A = "0 [0=No;1=Yes]"
    B = "0 [0=No;1=Yes]"
    C = "0 [0=No;1=Yes]"
    D = "1 [0=No;1=Yes]"
    E = "1 [0=No;1=Yes]"
    F = "0 [0=No;1=Yes]"
    G = "0 [0=No;1=Yes]"
    }
   0.import([234,432],0,0,40)
    {
    Name = "CMIC"
    }
   0.import([234,774],0,0,90)
    {
    Name = "GMES"
    }
   0.mingam([342,774],0,0,100)
    {
    FREQ = "50.0 [Hz]"
    }
   -Wire-([378,774],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   0.datalabel([414,432],0,0,-1)
    {
    Name = "CMIS"
    }
   0.datalabel([522,774],2,0,-1)
    {
    Name = "GMESS"
    }
   0.pgb([486,468],0,24460032,70)
    {
    Name = "Current (filtered)"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([522,810],0,24460432,110)
    {
    Name = "Gamma"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "57.29578"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.realpole([342,432],0,0,60)
    {
    Limit = "0 [0=No;1=Yes]"
    COM = "Real_Pole"
    Reset = "0 [0=No;1=Yes]"
    YO = "0.0"
    G = "0.5"
    T = "0.0012 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.upramp([630,666],0,0,210)
    {
    X1 = "0.0 [pu]"
    X2 = "0.1 [pu]"
    Y2 = "0.2793 [pu]"
    COM = "Up_Ramp_X-fer_Func"
    }
   -Wire-([486,468],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([594,666],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.const([522,882],0,0,130)
    {
    Name = ""
    Value = "0.2618"
    }
   0.datalabel([630,882],2,0,-1)
    {
    Name = "GMIN"
    }
   -Wire-([522,810],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([414,432],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([738,360],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([738,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([486,432],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.pgb([684,288],0,24466440,340)
    {
    Name = "Voltage Dep. Current Limit"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([882,288],0,25111736,330)
    {
    Name = "Rectifier Current Order"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([846,360],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datalabel([882,252],2,0,-1)
    {
    Name = "CORD"
    }
   0.maxmin([810,252],6,0,170)
    {
    DPath = "1 [0=Integer;1=Real]"
    Type = "0 [0=Minimum;1=Maximum]"
    A = "0 [0=No;1=Yes]"
    B = "0 [0=No;1=Yes]"
    C = "0 [0=No;1=Yes]"
    D = "1 [0=No;1=Yes]"
    E = "1 [0=No;1=Yes]"
    F = "0 [0=No;1=Yes]"
    G = "0 [0=No;1=Yes]"
    }
   0.export([1386,252],2,0,320)
    {
    Name = "CORDER"
    }
   -Wire-([882,288],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([846,252],0,0,-1)
    {
    Vertex="0,0;504,0"
    }
   0.import([234,252],0,0,20)
    {
    Name = "VDCI"
    }
   0.datalabel([684,252],2,0,-1)
    {
    Name = "VDCL"
    }
   0.datalabel([486,252],0,0,-1)
    {
    Name = "MPVS"
    }
   0.realpole([342,252],0,0,30)
    {
    Limit = "0 [0=No;1=Yes]"
    COM = "Real_Pole"
    Reset = "0 [0=No;1=Yes]"
    YO = "0.0"
    G = "0.002"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([666,252],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.txferfnc([630,252],0,0,160)
    {
    X1 = "0.4"
    Y1 = "0.55"
    X2 = "0.9"
    Y2 = "1.0"
    GL = "0.0"
    GU = "1.0"
    COM = "Generic_X-fer_Func"
    }
   -Wire-([486,198],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.gain([414,360],3,0,140)
    {
    G = "0.01"
    COM = "Gain"
    Dim = "1"
    }
   0.sumjct([414,252],0,0,150)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "0 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   -Wire-([414,324],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([450,252],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([684,288],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([558,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.mult([558,360],6,0,270)
    {
    }
   0.pgb([648,360],0,25123272,310)
    {
    Name = "Power"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([738,126],2,0,-1)
    {
    Name = "CO"
    }
   0.var([630,126],0,25124344,10)
    {
    Name = "IOrder"
    Group = "Inverter"
    Display = "0 [0=No;1=Yes]"
    Max = "1.5"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1 [1=Continuous;0=On Release]"
    }
   -Wire-([666,126],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([738,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,216],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([594,360],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([612,360],2,0,-1)
    {
    Name = "POWER"
    }
   -Wire-([486,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([36,36],0)
    {
    Name = "Untitled"
    Font = 2
    Bounds = 36,36,270,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
INVERTER  CONTROLS 
"
    }
   -Wire-([594,594],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Sticky-([216,630],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 216,630,378,684
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\

INVERTER  GAMMA CONTROLS 
"
    }
   -Sticky-([216,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 216,126,396,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\

INVERTER  CURRENT CONTROLS 
"
    }
   -Sticky-([432,288],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 432,288,540,324
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "voltage compounding"
    }
   -Sticky-([198,486],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,486,324,540
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "dc  current measured at inverter"
    }
   -Sticky-([198,306],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,306,306,360
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "dc  voltage measured at inverter"
    }
   -Sticky-([630,36],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 630,36,720,72
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "input current order (pu)"
    }
   -Wire-([1278,630],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([1332,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1332,162,1422,198
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "current  order for rectifier"
    }
   -Sticky-([1332,540],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1332,540,1440,576
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Angle Order for inverter"
    }
   -Sticky-([198,828],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,828,270,882
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Gamma Angle measured at inverter"
    }
   -Sticky-([486,936],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,936,594,972
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Minimum Gamma Angle = 15deg"
    }
   0.pgb([486,198],0,23933568,350)
    {
    Name = "DC Voltage (compensated)"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "0 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.emtconst([1206,576],0,0,80)
    {
    Name = ""
    Value = "0"
    }
   }
  }
 Module("Rectifier_AC")
  {
  Desc = "Rectifier AC System"
  FileDate = 1144361330
  Nodes = 
   {
   Electrical("N",0,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(,,ByNode,N)
   Line(0,0,0,-40)
   Pen(,,0.2)
   Arc(-7,-53,0,-46,0,-180)
   Arc(0,-53,6,-46,0,180)
   Ellipse(-12,-61,11,-39)
   Text(-1,-65,"%:Name")
   }


  Page(A/A4,Landscape,16,[597,467],5)
   {
   0.inductor([234,216],4,0,-1)
    {
    L = "0.151 [H]"
    }
   0.resistor([234,252],4,0,-1)
    {
    R = "2160.633 [ohm]"
    }
   -Wire-([252,216],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([198,216],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([180,216],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([198,252],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.ground([90,216],2,0,-1)
    {
    }
   -Sticky-([144,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 144,72,288,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
 rectifier ac system

    SCR = 2.5 @  84.0 deg
    345.0 kV
    50Hz"
    }
   0.source3([126,216],0,0,-1)
    {
    Name = "RectSrc"
    Type = "1 [1=R;2=L;3=R//L;4=R-R//L]"
    Ctrl = "0 [0=Fixed;2=External;3=Auto]"
    MVA = "100.0 [MVA]"
    Vm = "382.8672 [kV]"
    F = "50.0 [Hz]"
    Tc = "0.05 [s]"
    ZSeq = "0 [0=No;1=Yes]"
    Imp = "0 [0=RRL Values;1=Impedance]"
    Exph = "0 [0=Radians;1=Degrees]"
    View = "1 [0=3 phase view;1=Single line view]"
    Term = "0 [0=Behind the Source Impedance;1=At the Terminal]"
    R1s = "3.737 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "3.737 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "3.737 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "3.737 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "382.8672 [kV]"
    F0 = "50.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0 [0=No;1=Yes]"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0 [0=No;1=Yes]"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([360,216],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.xnode([360,216],0,0,-1)
    {
    Name = "N"
    }
   }
  }
 Module("Rectifier")
  {
  Desc = ""
  FileDate = 1144361330
  Nodes = 
   {
   Electrical("AC",-72,0)
    {
    Dim  = [3]
    }
   Electrical("DCP",72,-72)
    {
    }
   }

  Graphics = 
   {
   Line(12,-72,12,-64)
   Line(72,-72,12,-72)
   Pen(,,ByNode)
   Line(-60,0,-72,0)
   Pen(,,0.2)
   Rectangle(-7,-64,31,-29)
   Pen(,,0.4)
   Line(12,-38,12,-32)
   Line(-2,-38,26,-38)
   Line(12,-57,-2,-38)
   Line(12,-57,26,-38)
   Line(-1,-57,26,-57)
   Line(12,-62,12,-57)
   Pen(,,0.2)
   Line(43,-77,39,-80)
   Line(39,-74,43,-77)
   Line(24,-77,43,-77)
   Line(12,-29,12,29)
   Line(4,72,20,72)
   Line(-18,-45,-7,-45)
   Line(-18,54,-8,54)
   Line(-18,54,-18,-45)
   Ellipse(-52,-10,-32,10)
   Pen(,,ByNode)
   Line(-19,0,-32,0)
   Pen(,,0.2)
   Line(12,64,12,72)
   Rectangle(-7,29,31,64)
   Pen(,,0.4)
   Line(12,61,12,55)
   Line(-2,55,26,55)
   Line(26,55,12,36)
   Line(-2,55,12,36)
   Line(-2,36,25,36)
   Line(12,36,12,31)
   Pen(,,0.2)
   Ellipse(-60,-10,-40,10)
   Line(6,75,18,75)
   Line(10,78,14,78)
   Text(18,95,"%:Name")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   0.ground([522,720],1,0,-1)
    {
    }
   -Wire-([396,396],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([396,468],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.capacitor([342,468],4,0,-1)
    {
    C = "6.685 [uF]"
    }
   -Wire-([306,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([306,450],4,0,-1)
    {
    R = "83.32 [ohm]"
    }
   0.inductor([306,486],4,0,-1)
    {
    L = "0.0136 [H]"
    }
   -Wire-([270,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([270,468],4,0,-1)
    {
    }
   0.capacitor([306,396],0,0,-1)
    {
    C = "6.685 [uF]"
    }
   0.resistor([234,378],4,0,-1)
    {
    R = "29.76 [ohm]"
    }
   0.capacitor([270,378],0,0,-1)
    {
    C = "74.28 [uF]"
    }
   0.inductor([234,378],6,0,-1)
    {
    L = "0.1364 [H]"
    }
   0.ground([162,396],4,0,-1)
    {
    }
   -Wire-([306,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([306,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([234,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([198,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([270,414],4,0,-1)
    {
    R = "261.87 [ohm]"
    }
   0.compare([882,702],4,0,120)
    {
    X = "0.04"
    OL = "0.0"
    OH = "1.0"
    INTR = "0 [0=Disabled;1=Enabled]"
    }
   0.ground([306,540],4,0,-1)
    {
    }
   0.capacitor([342,540],4,0,-1)
    {
    C = "3.342 [uF]"
    }
   -Wire-([396,540],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([396,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([504,468],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 504,468,612,504
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
rectifier
    1000MW, 500kV"
    }
   0.pin([396,468],5,0,-1)
    {
    }
   0.pin([396,396],5,0,-1)
    {
    }
   0.nodeloop([396,270],3,0,20)
    {
    View = "1 [0=3 phase view;1=Single line view]"
    }
   -Wire-([396,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([504,396],1,0,-1)
    {
    }
   0.nodeloop([396,558],3,0,30)
    {
    View = "1 [0=3 phase view;1=Single line view]"
    }
   0.ground([504,684],1,0,-1)
    {
    }
   0.resistor([522,684],7,0,-1)
    {
    R = "1.0 [Mohm]"
    }
   -Wire-([666,270],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([432,558],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([666,558],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([558,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([666,738],1,0,-1)
    {
    }
   -Wire-([558,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([720,396],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([756,612],0,0,-1)
    {
    Name = "GRS"
    }
   0.datalabel([756,594],2,0,-1)
    {
    Name = "ARS"
    }
   0.datalabel([756,306],2,0,-1)
    {
    Name = "ARD"
    }
   0.datalabel([756,324],0,0,-1)
    {
    Name = "GRD"
    }
   -Wire-([720,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.time-sig([954,702],4,0,40)
    {
    }
   0.datalabel([810,702],0,0,-1)
    {
    Name = "KBR"
    }
   -Wire-([720,702],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.xfmr-3p2w([522,648],0,0,-1)
    {
    Name = "TFMRYYR"
    Tmva = "603.73 [MVA]"
    f = "50.0 [Hz]"
    YD1 = "0 [0=Y;1=Delta]"
    YD2 = "0 [0=Y;1=Delta]"
    Lead = "1 [1=Lags;2=Leads]"
    Xl = "0.18 [pu]"
    Ideal = "0 [0=No;1=Yes]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0 [0=None;1=#1;2=#2]"
    View = "1 [0=3 phase view;1=Single line (circles);2=Single line (windings)]"
    Dtls = "0 [0=No;1=Yes]"
    V1 = "345.0 [kV]"
    V2 = "213.4557 [kV]"
    Enab = "1 [0=No;1=Yes]"
    Sat = "2 [1=#1;2=#2]"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.g6p200([666,360],0,0,160)
    {
    UP = "1 [1=Up;0=Down]"
    FP = "0 [0=Angle in Radians;1=Array of 6 Pulses;2=6 Pulses + 6 Interp. times;3=Angle in Degrees]"
    SNUB = "1 [1=Yes;0=No]"
    KV = "-2 [1=+30 Deg;0=0 Deg (Y-Dlead);-1=-30 Deg (Y-Y or D-D);-2=-60 Deg (Y-Dlag)]"
    View = "1 [0=3 phase view;1=Single line view]"
    FR = "50.0 [Hz]"
    GP = "10.0"
    GI = "50.0"
    KP = "0 [1=Bus Voltage;0=Bus Voltage, Zero Sequence Removed;-1=Star Source Voltage;-2=Delta Source Voltage]"
    RON = "0.01 [ohm]"
    ROFF = "100000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   0.xfmr-3p2w([522,360],0,0,-1)
    {
    Name = "TFMRYDR"
    Tmva = "603.73 [MVA]"
    f = "50.0 [Hz]"
    YD1 = "0 [0=Y;1=Delta]"
    YD2 = "1 [0=Y;1=Delta]"
    Lead = "1 [1=Lags;2=Leads]"
    Xl = "0.18 [pu]"
    Ideal = "0 [0=No;1=Yes]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0 [0=None;1=#1;2=#2]"
    View = "1 [0=3 phase view;1=Single line (circles);2=Single line (windings)]"
    Dtls = "0 [0=No;1=Yes]"
    V1 = "345.0 [kV]"
    V2 = "213.4557 [kV]"
    Enab = "1 [0=No;1=Yes]"
    Sat = "2 [1=#1;2=#2]"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.g6p200([666,648],0,0,140)
    {
    UP = "1 [1=Up;0=Down]"
    FP = "0 [0=Angle in Radians;1=Array of 6 Pulses;2=6 Pulses + 6 Interp. times;3=Angle in Degrees]"
    SNUB = "1 [1=Yes;0=No]"
    KV = "-1 [1=+30 Deg;0=0 Deg (Y-Dlead);-1=-30 Deg (Y-Y or D-D);-2=-60 Deg (Y-Dlag)]"
    View = "1 [0=3 phase view;1=Single line view]"
    FR = "50.0 [Hz]"
    GP = "10.0"
    GI = "50.0"
    KP = "0 [1=Bus Voltage;0=Bus Voltage, Zero Sequence Removed;-1=Star Source Voltage;-2=Delta Source Voltage]"
    RON = "0.01 [ohm]"
    ROFF = "100000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   -Wire-([432,270],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([162,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Bus-([396,162],0,0,-1)
    {
    P1 = [0,0]
    P2 = [0,558]
    I = 1
    NAME = Rbus
    BASKV = 0.0
    IDE = 1
    GL = 0.0
    BL = 0.0
    AREA = 1
    ZONE = 1
    VM = 1.0
    VA = 0.0
    OWNER = 1
    }
   0.xnode([396,162],2,0,-1)
    {
    Name = "AC"
    }
   0.datalabel([792,396],2,0,-1)
    {
    Name = "AOR"
    }
   0.pgb([828,396],0,24858968,150)
    {
    Name = "Alpha Order"
    Group = "Rectifier"
    Display = "1 [0=No;1=Yes]"
    Scale = "57.29578"
    Units = ""
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.xnode([846,180],6,0,-1)
    {
    Name = "DCP"
    }
   0.datalabel([756,126],0,0,-1)
    {
    Name = "CMR"
    }
   0.pgb([810,90],0,23744264,180)
    {
    Name = "DC Volts"
    Group = "Rectifier"
    Display = "1 [0=No;1=Yes]"
    Scale = "0.002"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-0.5"
    Max = "2.0"
    }
   -Wire-([756,90],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([756,90],0,0,-1)
    {
    Name = "VDCR"
    }
   -Wire-([666,180],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([756,126],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([810,126],0,25001408,170)
    {
    Name = "DC Current"
    Group = "Rectifier"
    Display = "1 [0=No;1=Yes]"
    Scale = "0.5"
    Units = ""
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-0.5"
    Max = "2.0"
    }
   -Wire-([774,180],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.radiolink([882,1044],0,0,70)
    {
    Source = "Inverter"
    Name = "CORDER"
    dim = "1"
    Mode = "0 [0=Receive;1=Transmit]"
    Type = "0 [0=Analog;1=Digital]"
    }
   -Wire-([846,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1008,972],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([882,972],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([702,972],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([828,972],6,0,-1)
    {
    Name = "CMRS"
    }
   0.datalabel([666,972],6,0,-1)
    {
    Name = "CERRR"
    }
   0.realpole([918,972],4,0,50)
    {
    Limit = "0 [0=No;1=Yes]"
    COM = "Real_Pole"
    Reset = "0 [0=No;1=Yes]"
    YO = "0.0"
    G = "0.5"
    T = "0.0012 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.sumjct([738,972],4,0,80)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "0 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "-1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   -Wire-([738,1044],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([558,972],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([522,972],6,0,-1)
    {
    Name = "BETAR"
    }
   0.pi_ctlr([594,972],4,0,90)
    {
    GP = "1.0989"
    TI = "0.01092 [s]"
    YHI = "3.054"
    YLO = "0.52"
    YINIT = "1.57"
    Mthd = "0 [0=Trapezoidal;1=Rectangular]"
    INTR = "0 [0=Disabled;1=Enabled]"
    }
   -Wire-([846,1044],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([828,918],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([414,972],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.sumjct([450,972],4,0,100)
    {
    DPath = "1 [0=Integer;1=Real]"
    A = "0 [1=add;0=disable;-1=subtract]"
    B = "0 [1=add;0=disable;-1=subtract]"
    C = "0 [1=add;0=disable;-1=subtract]"
    D = "-1 [1=add;0=disable;-1=subtract]"
    E = "0 [1=add;0=disable;-1=subtract]"
    F = "1 [1=add;0=disable;-1=subtract]"
    G = "0 [1=add;0=disable;-1=subtract]"
    }
   -Wire-([450,1044],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Sticky-([144,972],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 144,972,252,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\

RECTIFIER  CURRENT
CONTROLS 
"
    }
   -Sticky-([954,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,864,1062,918
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
dc  current
measured
at rectifier"
    }
   -Sticky-([792,1098],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 792,1098,900,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
current  order
from inverter"
    }
   -Sticky-([324,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 324,882,396,918
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Angle Order 
for rectifier"
    }
   0.pgb([828,918],4,23659720,110)
    {
    Name = "Current (filtered)"
    Group = "Rectifier"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,972],6,0,-1)
    {
    Name = "AOR"
    }
   0.datalabel([1008,972],0,0,-1)
    {
    Name = "CMR"
    }
   0.datalabel([846,1044],0,0,-1)
    {
    Name = "CORDER"
    }
   -Plot-([126,1080],0)
    {
    Title = "$(Group)"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,504,468
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,203],"")
     {
     Options = 9
     Units = ""
     Curve(25254576,"AC Volts (RMS)",0,,,)
     Curve(25253320,"AC Voltage",0,,,)
     }
    Graph([0,203],[0,0,504,202],"")
     {
     Options = 9
     Units = ""
     Curve(23744264,"DC Volts",8388608,,,)
     Curve(25001408,"DC Current",32768,,,)
     }
    }
   -Wire-([720,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([792,684],0,0,-1)
    {
    Vertex="0,0;0,-288"
    }
   -Wire-([720,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([810,414],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.unity([810,702],4,0,130)
    {
    IType = "2"
    OType = "1"
    }
   0.multimeter([756,180],0,0,10)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "CMR"
    VolI = "VDCR"
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.emtconst([486,1044],4,0,60)
    {
    Name = ""
    Value = "0"
    }
   }
  }
 Module("Inverter")
  {
  Desc = ""
  FileDate = 1144361330
  Nodes = 
   {
   Electrical("AC",-90,0)
    {
    Dim  = [3]
    }
   Electrical("DCP",54,-72)
    {
    }
   }

  Graphics = 
   {
   Line(-6,-72,-6,-64)
   Line(54,-72,-6,-72)
   Pen(,,ByNode)
   Line(-78,0,-90,0)
   Pen(,,0.2)
   Rectangle(-25,-64,13,-29)
   Pen(,,0.4)
   Line(-6,-56,-6,-62)
   Line(8,-56,-20,-56)
   Line(-6,-37,8,-56)
   Line(-6,-37,-20,-56)
   Line(7,-37,-20,-37)
   Line(-6,-32,-6,-37)
   Pen(,,0.2)
   Line(11,-80,7,-77)
   Line(7,-77,11,-74)
   Line(7,-77,26,-77)
   Line(-6,-29,-6,29)
   Line(-36,-45,-25,-45)
   Line(-36,54,-26,54)
   Line(-36,54,-36,-45)
   Ellipse(-70,-10,-50,10)
   Pen(,,ByNode)
   Line(-37,0,-50,0)
   Pen(,,0.2)
   Line(-6,64,-6,72)
   Rectangle(-25,29,13,64)
   Pen(,,0.4)
   Line(-6,37,-6,31)
   Line(8,37,-20,37)
   Line(-6,56,8,37)
   Line(-6,56,-20,37)
   Line(7,56,-20,56)
   Line(-6,61,-6,56)
   Pen(,,0.2)
   Ellipse(-78,-10,-58,10)
   Line(-14,72,2,72)
   Line(-12,75,0,75)
   Line(-8,78,-4,78)
   Text(0,95,"%:Name")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   0.ground([630,720],7,0,-1)
    {
    }
   0.datalabel([342,702],0,0,-1)
    {
    Name = "KBI"
    }
   -Wire-([486,828],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,864],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([486,828],2,0,-1)
    {
    Name = "GMID"
    }
   0.datalabel([486,864],2,0,-1)
    {
    Name = "GMIS"
    }
   0.maxmin([414,828],4,0,110)
    {
    DPath = "1 [0=Integer;1=Real]"
    Type = "0 [0=Minimum;1=Maximum]"
    A = "0 [0=No;1=Yes]"
    B = "0 [0=No;1=Yes]"
    C = "0 [0=No;1=Yes]"
    D = "1 [0=No;1=Yes]"
    E = "1 [0=No;1=Yes]"
    F = "0 [0=No;1=Yes]"
    G = "0 [0=No;1=Yes]"
    }
   0.compare([270,702],0,0,50)
    {
    X = "0.04"
    OL = "0.0"
    OH = "1.0"
    INTR = "0 [0=Disabled;1=Enabled]"
    }
   -Wire-([810,450],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.capacitor([810,450],0,0,-1)
    {
    C = "15.04 [uF]"
    }
   -Wire-([846,432],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([846,432],0,0,-1)
    {
    R = "37.03 [ohm]"
    }
   0.inductor([846,468],0,0,-1)
    {
    L = "0.0061 [H]"
    }
   -Wire-([882,432],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([882,450],0,0,-1)
    {
    }
   -Wire-([810,378],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.capacitor([810,378],0,0,-1)
    {
    C = "15.04 [uF]"
    }
   0.resistor([918,360],0,0,-1)
    {
    R = "13.23 [ohm]"
    }
   0.capacitor([846,360],0,0,-1)
    {
    C = "167.2 [uF]"
    }
   0.inductor([882,360],6,0,-1)
    {
    L = "0.0606 [H]"
    }
   0.ground([972,378],0,0,-1)
    {
    }
   -Wire-([846,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([882,396],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([954,396],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([954,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([882,396],0,0,-1)
    {
    R = "116.38 [ohm]"
    }
   0.capacitor([810,522],0,0,-1)
    {
    C = "7.522 [uF]"
    }
   0.ground([846,522],0,0,-1)
    {
    }
   -Wire-([810,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([828,702],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Sticky-([540,468],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 540,468,648,504
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
 inverter
    1000MW, 500kV"
    }
   0.pin([756,450],7,0,-1)
    {
    }
   0.pin([756,378],7,0,-1)
    {
    }
   0.nodeloop([756,270],3,0,20)
    {
    View = "1 [0=3 phase view;1=Single line view]"
    }
   0.ground([648,396],7,0,-1)
    {
    }
   -Wire-([684,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.nodeloop([756,558],3,0,30)
    {
    View = "1 [0=3 phase view;1=Single line view]"
    }
   -Wire-([684,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([648,684],7,0,-1)
    {
    }
   0.resistor([630,684],1,0,-1)
    {
    R = "1000000.0 [ohm]"
    }
   0.tpflt([810,702],0,0,140)
    {
    Ctype = "0 [0=Internal;1=External]"
    OpCur = "0 [0=No;1=Yes]"
    Grnd = "1 [0=No;1=Yes]"
    View = "1 [0=3 phase view;1=Single line view]"
    CLVL = "0.0 [kA]"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    A = "0 [0=No;1=Yes]"
    B = "0 [0=No;1=Yes]"
    C = "0 [0=No;1=Yes]"
    G = "0 [0=No;1=Yes]"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tfault([882,738],0,0,70)
    {
    TF = "0.3 [s]"
    DF = "0.05 [s]"
    REP = "0 [0=No;1=Yes]"
    }
   -Wire-([486,558],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([486,270],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.ground([486,738],7,0,-1)
    {
    }
   -Wire-([522,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([522,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([504,558],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([504,270],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([396,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,306],2,0,-1)
    {
    Name = "AMID"
    }
   -Wire-([396,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,594],2,0,-1)
    {
    Name = "AMIS"
    }
   -Wire-([396,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([396,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([360,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([342,702],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.g6p200([486,360],4,0,80)
    {
    UP = "0 [1=Up;0=Down]"
    FP = "0 [0=Angle in Radians;1=Array of 6 Pulses;2=6 Pulses + 6 Interp. times;3=Angle in Degrees]"
    SNUB = "1 [1=Yes;0=No]"
    KV = "-2 [1=+30 Deg;0=0 Deg (Y-Dlead);-1=-30 Deg (Y-Y or D-D);-2=-60 Deg (Y-Dlag)]"
    View = "1 [0=3 phase view;1=Single line view]"
    FR = "50.0 [Hz]"
    GP = "10.0"
    GI = "50.0"
    KP = "0 [1=Bus Voltage;0=Bus Voltage, Zero Sequence Removed;-1=Star Source Voltage;-2=Delta Source Voltage]"
    RON = "0.01 [ohm]"
    ROFF = "100000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   0.g6p200([486,648],4,0,100)
    {
    UP = "0 [1=Up;0=Down]"
    FP = "0 [0=Angle in Radians;1=Array of 6 Pulses;2=6 Pulses + 6 Interp. times;3=Angle in Degrees]"
    SNUB = "1 [1=Yes;0=No]"
    KV = "-1 [1=+30 Deg;0=0 Deg (Y-Dlead);-1=-30 Deg (Y-Y or D-D);-2=-60 Deg (Y-Dlag)]"
    View = "1 [0=3 phase view;1=Single line view]"
    FR = "50.0 [Hz]"
    GP = "10.0"
    GI = "50.0"
    KP = "0 [1=Bus Voltage;0=Bus Voltage, Zero Sequence Removed;-1=Star Source Voltage;-2=Delta Source Voltage]"
    RON = "0.01 [ohm]"
    ROFF = "100000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   0.xfmr-3p2w([630,360],4,0,-1)
    {
    Name = "TFMRYDI"
    Tmva = "591.79 [MVA]"
    f = "50.0 [Hz]"
    YD1 = "0 [0=Y;1=Delta]"
    YD2 = "1 [0=Y;1=Delta]"
    Lead = "1 [1=Lags;2=Leads]"
    Xl = "0.18 [pu]"
    Ideal = "0 [0=No;1=Yes]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0 [0=None;1=#1;2=#2]"
    View = "1 [0=3 phase view;1=Single line (circles);2=Single line (windings)]"
    Dtls = "0 [0=No;1=Yes]"
    V1 = "230.0 [kV]"
    V2 = "209.2288 [kV]"
    Enab = "1 [0=No;1=Yes]"
    Sat = "2 [1=#1;2=#2]"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.xfmr-3p2w([630,648],4,0,-1)
    {
    Name = "TFMRYYI"
    Tmva = "591.79 [MVA]"
    f = "50.0 [Hz]"
    YD1 = "0 [0=Y;1=Delta]"
    YD2 = "0 [0=Y;1=Delta]"
    Lead = "1 [1=Lags;2=Leads]"
    Xl = "0.18 [pu]"
    Ideal = "0 [0=No;1=Yes]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0 [0=None;1=#1;2=#2]"
    View = "1 [0=3 phase view;1=Single line (circles);2=Single line (windings)]"
    Dtls = "0 [0=No;1=Yes]"
    V1 = "230.0 [kV]"
    V2 = "209.2288 [kV]"
    Enab = "1 [0=No;1=Yes]"
    Sat = "2 [1=#1;2=#2]"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.datalabel([396,324],4,0,-1)
    {
    Name = "GMID"
    }
   0.datalabel([396,612],4,0,-1)
    {
    Name = "GMIS"
    }
   -Bus-([756,162],0,0,-1)
    {
    P1 = [0,0]
    P2 = [0,558]
    I = 1
    NAME = Ibus
    BASKV = 0.0
    IDE = 1
    GL = 0.0
    BL = 0.0
    AREA = 1
    ZONE = 1
    VM = 1.0
    VA = 0.0
    OWNER = 1
    }
   -Plot-([612,864],0)
    {
    Title = "$(Group)"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,504,468
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,203],"")
     {
     Options = 9
     Units = ""
     Curve(25429560,"AC Volts (RMS)",0,,,)
     Curve(24764688,"AC Voltage",0,,,)
     }
    Graph([0,203],[0,0,504,202],"")
     {
     Options = 9
     Units = ""
     Curve(24839608,"DC Volts",8388608,,,)
     Curve(23645840,"DC Current",32768,,,)
     }
    }
   0.xnode([756,162],6,0,-1)
    {
    Name = "AC"
    }
   0.datalabel([180,882],4,0,-1)
    {
    Name = "AOI"
    }
   0.datalabel([360,828],6,0,-1)
    {
    Name = "GMES"
    }
   0.datalabel([360,864],6,0,-1)
    {
    Name = "VDCI"
    }
   0.datalabel([360,900],6,0,-1)
    {
    Name = "CMI"
    }
   -Wire-([216,882],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([378,828],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([216,846],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Sticky-([414,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 414,882,522,936
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Gamma Angle 
measured 
at inverter"
    }
   -Wire-([360,900],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,864],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .InvCtl([270,864],4,0,90)
    {
    }
   0.datalabel([360,522],3,0,-1)
    {
    Name = "AOI"
    }
   0.datalabel([180,846],2,0,-1)
    {
    Name = "CORDER"
    }
   0.short([954,378],0,0,-1)
    {
    }
   0.time-sig([198,702],0,0,40)
    {
    }
   0.xnode([306,180],6,0,-1)
    {
    Name = "DCP"
    }
   0.pgb([414,126],0,24839608,150)
    {
    Name = "DC Volts"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "0.002"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-0.5"
    Max = "2.0"
    }
   0.datalabel([360,126],0,0,-1)
    {
    Name = "VDCI"
    }
   -Wire-([360,126],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([414,90],0,23645840,160)
    {
    Name = "DC Current"
    Group = "Inverter"
    Display = "1 [0=No;1=Yes]"
    Scale = "0.5"
    Units = ""
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-0.5"
    Max = "2.0"
    }
   0.datalabel([360,90],0,0,-1)
    {
    Name = "CMI"
    }
   -Wire-([360,90],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([414,180],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.nodelabel([486,180],2,0,-1)
    {
    Name = "DCIC"
    MeasV = "0 [0=No;1=Yes]"
    PU = "0 [0=No;1=Yes]"
    VName = "VNode"
    VBase = "1.0 [kV]"
    }
   -Wire-([306,180],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.radiolink([144,846],4,0,120)
    {
    Source = "Inverter"
    Name = "CORDER"
    dim = "1"
    Mode = "1 [0=Receive;1=Transmit]"
    Type = "0 [0=Analog;1=Digital]"
    }
   -Wire-([180,846],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.pgb([180,774],4,44852488,130)
    {
    Name = "Current Order"
    Group = "Rectifier"
    Display = "1 [0=No;1=Yes]"
    Scale = "1.0"
    Units = ""
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([180,774],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([342,702],0,0,-1)
    {
    Vertex="0,0;0,-288"
    }
   -Wire-([342,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([360,684],0,0,-1)
    {
    Vertex="0,0;0,-288"
    }
   -Wire-([360,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.unity([342,702],0,0,60)
    {
    IType = "2"
    OType = "1"
    }
   0.multimeter([396,180],0,0,10)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "CMI"
    VolI = "VDCI"
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   }
  }
 Module("Inverter_AC")
  {
  Desc = "Inverter AC System"
  FileDate = 1144361330
  Nodes = 
   {
   Electrical("N",0,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(,,ByNode,N)
   Line(0,0,0,-40)
   Pen(,,0.2)
   Arc(-7,-53,0,-46,0,-180)
   Arc(0,-53,6,-46,0,180)
   Ellipse(-12,-61,11,-39)
   Text(-1,-65,"%:Name")
   }


  Page(A/A4,Landscape,16,[597,467],5)
   {
   -Wire-([198,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.inductor([198,270],6,0,-1)
    {
    L = "36.5 [mH]"
    }
   0.inductor([270,306],4,0,-1)
    {
    L = "36.5 [mH]"
    }
   0.resistor([342,306],4,0,-1)
    {
    R = "0.7406 [ohm]"
    }
   0.resistor([270,270],6,0,-1)
    {
    R = "24.81 [ohm]"
    }
   -Wire-([306,306],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([234,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([270,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([378,270],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([342,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([450,270],6,0,-1)
    {
    }
   0.pin([342,270],7,0,-1)
    {
    }
   0.pin([234,270],7,0,-1)
    {
    }
   0.source3([414,270],4,0,-1)
    {
    Name = "InvSrc"
    Type = "1 [1=R;2=L;3=R//L;4=R-R//L]"
    Ctrl = "0 [0=Fixed;2=External;3=Auto]"
    MVA = "100.0 [MVA]"
    Vm = "215.05 [kV]"
    F = "50.0 [Hz]"
    Tc = "0.05 [s]"
    ZSeq = "0 [0=No;1=Yes]"
    Imp = "0 [0=RRL Values;1=Impedance]"
    Exph = "0 [0=Radians;1=Degrees]"
    View = "1 [0=3 phase view;1=Single line view]"
    Term = "0 [0=Behind the Source Impedance;1=At the Terminal]"
    R1s = "0.7406 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "3.737 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "3.737 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "3.737 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "215.05 [kV]"
    F0 = "50.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0 [0=No;1=Yes]"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0 [0=No;1=Yes]"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([198,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,126,342,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
 inverter ac system

    SCR = 2.5 @ 75.0 deg
    230.0 kV
    50Hz"
    }
   0.xnode([162,270],0,0,-1)
    {
    Name = "N"
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Working Page"
  FileDate = 1144361329
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-33,-16,33,16)
   Font(,Medium)
   Text(0,6,"Case")
   }


  Page(A/A4,Portrait,112,[597,467],100)
   {
   -Sticky-([450,36],0)
    {
    Name = ""
    Font = 2
    Bounds = 450,36,738,144
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
CIGRE BENCHMARK MODEL
for
HVDC CONTROLS"
    }
   .Inverter_AC([954,378],1,0,60)
    {
    }
   -Bus-([918,342],0,0,-1)
    {
    P1 = [0,0]
    P2 = [0,72]
    I = 1
    NAME = Ibus
    BASKV = 0.0
    IDE = 1
    GL = 0.0
    BL = 0.0
    AREA = 1
    ZONE = 1
    VM = 1.0
    VA = 0.0
    OWNER = 1
    }
   -ControlPanel-([846,612],0)
    {
    Name = "$(GROUP)"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 846,612
    Extents = 0,0,0,0
    Slider(25124344)
    Meter(25429560)
    Meter(24839608)
    }
   -Plot-([594,756],0)
    {
    Title = "Inverter"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,468,450
    XLabel = ""
    AutoPan = "true,75"
    Graph([0,0],[0,0,468,194],"Voltage")
     {
     Options = 8
     Units = "pu"
     Curve(25429560,"AC Volts (RMS)",0,,,)
     Curve(24764688,"AC Voltage",0,,,)
     }
    Graph([0,194],[0,0,468,193],"")
     {
     Options = 0
     Units = "pu"
     Curve(24839608,"DC Volts",8388608,,,)
     Curve(23645840,"DC Current",32768,,,)
     }
    }
   -ControlPanel-([126,612],0)
    {
    Name = "$(Group)"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 126,612
    Extents = 0,0,72,126
    Meter(25254576)
    Meter(23744264)
    }
   -Plot-([126,756],0)
    {
    Title = "Rectifier"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,468,450
    XLabel = ""
    AutoPan = "true,75"
    Graph([0,0],[0,0,468,194],"Voltage")
     {
     Options = 8
     Units = "pu"
     Curve(25254576,"AC Volts (RMS)",0,,,)
     Curve(25253320,"AC Voltage",0,,,)
     }
    Graph([0,194],[0,0,468,193],"")
     {
     Options = 0
     Units = "pu"
     Curve(23744264,"DC Volts",8388608,,,)
     Curve(25001408,"DC Current",32768,,,)
     }
    }
   .Inverter([828,378],4,0,40)
    {
    }
   .Rectifier([342,378],0,0,30)
    {
    }
   0.inductor([738,306],6,0,-1)
    {
    L = "0.5968 [H]"
    }
   0.resistor([630,306],6,0,-1)
    {
    R = "2.5 [ohm]"
    }
   -Wire-([558,306],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.inductor([450,306],2,0,-1)
    {
    L = "0.5968 [H]"
    }
   0.resistor([558,306],2,0,-1)
    {
    R = "2.5 [ohm]"
    }
   0.capacitor([594,378],1,0,-1)
    {
    C = "26.0 [uF]"
    }
   0.ground([594,414],1,0,-1)
    {
    }
   -Sticky-([54,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,108,432,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Monopolar  HVDC System
 12 pulse, 500 KV, 1000 MW
 Reactive power:  fixed capacitors 
 Filters: damped filters
 SCR:   rectifier: 2.5;   inverter:  2.5
"
    }
   -Sticky-([774,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 774,108,1134,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Reference
  M. Szechtman, T.  Wess, C.V. Thio,
  \"First Benchmark Model for HVDC Control Studies\", 
   Electra, No. 135, April 1991.
"
    }
   -Wire-([450,306],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([666,306],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([594,306],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Bus-([270,342],0,0,-1)
    {
    P1 = [0,0]
    P2 = [0,72]
    I = 1
    NAME = Rbus
    BASKV = 0.0
    IDE = 1
    GL = 0.0
    BL = 0.0
    AREA = 1
    ZONE = 1
    VM = 1.0
    VA = 0.0
    OWNER = 1
    }
   .Rectifier_AC([234,378],3,0,10)
    {
    }
   0.pgb([252,504],0,25253320,70)
    {
    Name = "AC Voltage"
    Group = "Rectifier"
    Display = "0 [0=No;1=Yes]"
    Scale = "0.00355"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([216,504],2,0,-1)
    {
    Name = "VacR"
    }
   0.pgb([252,540],0,25254576,80)
    {
    Name = "AC Volts (RMS)"
    Group = "Rectifier"
    Display = "0 [0=No;1=Yes]"
    Scale = "1.0"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "0"
    Max = "2.0"
    }
   0.multimeter([252,378],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "345.0 [kV]"
    TS = "0.02 [s]"
    Freq = "50.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "VacR"
    P = ""
    Q = ""
    Vrms = "VrmsR"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([216,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([216,540],2,0,-1)
    {
    Name = "VrmsR"
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([954,504],0,24764688,90)
    {
    Name = "AC Voltage"
    Group = "Inverter"
    Display = "0 [0=No;1=Yes]"
    Scale = "0.005325"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([954,540],0,25429560,100)
    {
    Name = "AC Volts (RMS)"
    Group = "Inverter"
    Display = "0 [0=No;1=Yes]"
    Scale = "1.0"
    Units = "pu"
    mrun = "1 [0=Last Run Only;1=All Runs]"
    Pol = "0"
    Min = "0"
    Max = "2.0"
    }
   0.multimeter([936,378],0,0,50)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "230.0 [kV]"
    TS = "0.02 [s]"
    Freq = "50.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "VacI"
    P = ""
    Q = ""
    Vrms = "VrmsI"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([918,504],2,0,-1)
    {
    Name = "VacI"
    }
   -Wire-([918,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([918,540],2,0,-1)
    {
    Name = "VrmsI"
    }
   -Wire-([918,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 }

